/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.segments;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import kickass.common.diagnostics.AsmError;
import kickass.nonasm.c64.SidFile;
import kickass.nonasm.tools.StreamUtil;
import kickass.nonasm.tools.StringUtil;
import kickass.nonasm.tools.tuples.Pair;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.NullValue;
import kickass.pass.values.Value;
import kickass.plugins.impl.PluginValue;
import kickass.plugins.interf.general.IValue;
import kickass.plugins.interf.segmentmodifier.ISegmentModifier;
import kickass.state.EvaluationState;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentManager;
import kickass.state.segments.SegmentMemoryBlock;
import kickass.state.segments.resolvers.AfterSegmentStartResolver;
import kickass.state.segments.resolvers.ConstantStartResolver;
import kickass.state.segments.resolvers.IStartResolver;

public class SegmentParser {
    public static final String param_prgFiles = "prgFiles";
    public static final String param_sidFiles = "sidFiles";
    public static final String param_allowOverlap = "allowOverlap";
    public static final String param_modify = "modify";
    public static final String param_segments = "segments";
    public static final String param_min = "min";
    public static final String param_max = "max";
    public static final String param_fill = "fill";
    public static final String param_fillByte = "fillByte";
    public static final String param_hide = "hide";
    public static final String param_start = "start";
    public static final String param_startAfter = "startAfter";
    public static final String param_virtual = "virtual";
    public static final String param_align = "align";
    public static final String param_outPrg = "outPrg";
    public static final String param_outBin = "outBin";
    public static final String param_dest = "dest";
    public static final String param_bank = "bank";
    public static final String param_loadInto = "loadInto";
    public static final Set<String> combiParameters;
    public static final Set<String> codeInputParameters;

    public static Segment createGeneralSegment(String string, ParameterMap parameterMap, SourceRange sourceRange, EvaluationState evaluationState) {
        Object object;
        Object object2;
        Object object3;
        Object object5;
        Object object6;
        String string2;
        boolean bl;
        boolean bl2;
        Segment segment = new Segment(string, sourceRange);
        segment.setIsHidden(parameterMap.getBoolValue(param_hide, false));
        segment.setMin(parameterMap.getIntValue(param_min, 0));
        segment.setMax(parameterMap.getIntValue(param_max, -1));
        segment.setAllowOverlappingMemoryBlocks(parameterMap.getBoolValue(param_allowOverlap, false));
        segment.setFill(parameterMap.getBoolValue(param_fill, false));
        segment.setFillByte((byte)parameterMap.getIntValue(param_fillByte, 0));
        boolean bl3 = bl2 = parameterMap.exist(param_min) && parameterMap.exist(param_max);
        if (bl2 && segment.getMin() > segment.getMax()) {
            evaluationState.diagnosticMgr.add(new AsmError("Min can't be greater than max. Min=" + StringUtil.toHex(segment.getMin()) + ", max=" + StringUtil.toHex(segment.getMax()), parameterMap.getNameRange(param_min)));
        }
        boolean bl4 = bl = parameterMap.exist(param_fill) && (!parameterMap.exist(param_min) || !parameterMap.exist(param_max));
        if (bl) {
            segment.setFill(false);
            evaluationState.diagnosticMgr.add(new AsmError("Cant use fill without both min and max", parameterMap.getNameRange(param_fill)));
        }
        if ((string2 = parameterMap.getStringValue(param_prgFiles)) != null) {
            object6 = parameterMap.getNameRange(param_prgFiles);
            for (String string3 : object5 = string2.split(",")) {
                if ((string3 = string3.trim()).isEmpty() || (object3 = SegmentParser.loadPrgFile(string3, (SourceRange)object6, evaluationState)) == null) continue;
                object2 = new File(string3).getName();
                object = new SegmentMemoryBlock((String)object2, false);
                ((SegmentMemoryBlock)object).setStart((Integer)((Pair)object3).getA());
                ((SegmentMemoryBlock)object).addDoneEntry((byte[])((Pair)object3).getB(), (SourceRange)object6);
                ((SegmentMemoryBlock)object).closeForNewEntries();
                segment.addMemoryBlock((SegmentMemoryBlock)object);
            }
        }
        if ((object6 = parameterMap.getStringValue(param_sidFiles)) != null) {
            String[] stringArray;
            object5 = parameterMap.getNameRange(param_sidFiles);
            String[] stringArray2 = stringArray = ((String)object6).split(",");
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                object3 = stringArray2[i];
                if (((String)(object3 = ((String)object3).trim())).isEmpty() || (object2 = SegmentParser.loadSidFile((String)object3, (SourceRange)object5, evaluationState)) == null) continue;
                object = new File((String)object3).getName();
                SegmentMemoryBlock segmentMemoryBlock = new SegmentMemoryBlock((String)object, false);
                segmentMemoryBlock.setStart(((SidFile)object2).getLocation());
                segmentMemoryBlock.addDoneEntry(((SidFile)object2).getData(), (SourceRange)object5);
                segmentMemoryBlock.closeForNewEntries();
                segment.addMemoryBlock(segmentMemoryBlock);
            }
        }
        if (parameterMap.exist(param_segments)) {
            for (String string4 : object5 = parameterMap.getStringValue(param_segments).split(",")) {
                if ((string4 = string4.trim()).isEmpty()) continue;
                segment.addSubSegmentIds(string4);
            }
        }
        if ((object5 = SegmentParser.getModifyConstant(parameterMap, evaluationState, true)) != null) {
            ISegmentModifier iSegmentModifier = evaluationState.namespaceMgr.getCurrentNamespace().getSegmentModifierPlugins().get((String)object5);
            if (iSegmentModifier == null) {
                evaluationState.diagnosticMgr.add(new AsmError("Unknown modifier '" + (String)object5 + "'", sourceRange));
            } else {
                segment.setModifier(iSegmentModifier);
                segment.setModifierArgs(parameterMap);
            }
        }
        return segment;
    }

    private static void addModifierArgs(ParameterMap parameterMap, ArrayList<IValue> arrayList, String string, int n) {
        if (!parameterMap.exist(string)) {
            return;
        }
        while (arrayList.size() <= n) {
            arrayList.add(new PluginValue(NullValue.instance, null));
        }
        PluginValue pluginValue = new PluginValue(parameterMap.getValue(string), parameterMap.getNameRange(string));
        arrayList.set(n, pluginValue);
    }

    private static Pair<Integer, byte[]> loadPrgFile(String string, SourceRange sourceRange, EvaluationState evaluationState) {
        InputStream inputStream = evaluationState.fileMgr.openFile(string, false);
        if (inputStream == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Can't open file '" + string + "'", sourceRange));
            return null;
        }
        byte[] byArray = new byte[2];
        int n = 0;
        try {
            n = inputStream.read(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n < 2) {
            evaluationState.diagnosticMgr.add(new AsmError("File '" + string + "' is too short. Must contain at least two address bytes.", sourceRange));
            return null;
        }
        int n2 = (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        byte[] byArray2 = StreamUtil.readBytes(inputStream);
        if (byArray2 == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Can't read file '" + string + "'", sourceRange));
            return null;
        }
        return new Pair<Integer, byte[]>(n2, byArray2);
    }

    private static SidFile loadSidFile(String string, SourceRange sourceRange, EvaluationState evaluationState) {
        InputStream inputStream = evaluationState.fileMgr.openFile(string, false);
        if (inputStream == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Can't open file '" + string + "'", sourceRange));
            return null;
        }
        byte[] byArray = StreamUtil.readBytes(inputStream);
        if (byArray == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Can't read file '" + string + "'", sourceRange));
            return null;
        }
        return new SidFile(byArray, sourceRange);
    }

    public static Segment createCombiSegment(String string, ParameterMap parameterMap, SourceRange sourceRange, EvaluationState evaluationState) {
        Segment segment = SegmentParser.createGeneralSegment(string, parameterMap, sourceRange, evaluationState);
        segment.setIsIntermediate(true);
        return segment;
    }

    public static Segment createCodeInputSegment(String string, ParameterMap parameterMap, SourceRange sourceRange, EvaluationState evaluationState) {
        Segment segment = SegmentParser.createGeneralSegment(string, parameterMap, sourceRange, evaluationState);
        segment.setBank(!parameterMap.exist(param_bank) ? NullValue.instance : parameterMap.getValue(param_bank));
        segment.setLoadInto(parameterMap.getStringValue(param_loadInto, ""));
        segment.setDestination(parameterMap.getStringValue(param_dest, ""));
        Integer n = parameterMap.getIntegerValue(param_align, null);
        if (n != null && n <= 0) {
            evaluationState.diagnosticMgr.add(new AsmError("Invalid align value: " + n, parameterMap.getNameRange(param_align)));
            n = null;
        }
        segment.setAlign(n);
        segment.setIsVirtual(parameterMap.getBoolValue(param_virtual, false));
        segment.setOutPrg(parameterMap.getStringValue(param_outPrg, null));
        segment.setOutBin(parameterMap.getStringValue(param_outBin, null));
        IStartResolver iStartResolver = SegmentManager.defaultStartResolver;
        if (parameterMap.exist(param_start)) {
            iStartResolver = new ConstantStartResolver(parameterMap.getIntValue(param_start), segment.getAlign());
        } else if (parameterMap.exist(param_startAfter)) {
            String string2 = parameterMap.getStringValue(param_startAfter);
            iStartResolver = new AfterSegmentStartResolver(string2, segment.getAlign(), sourceRange, evaluationState);
        }
        segment.setStartResolver(iStartResolver);
        return segment;
    }

    public static void addErrorIfNotExists(ParameterMap parameterMap, Set<String> set, boolean bl, EvaluationState evaluationState) {
        parameterMap.addErrorIfNotExist(set, evaluationState);
        if (!bl) {
            return;
        }
        String string = SegmentParser.getModifyConstant(parameterMap, evaluationState, false);
        if (string == null) {
            return;
        }
        ISegmentModifier iSegmentModifier = evaluationState.namespaceMgr.getCurrentNamespace().getSegmentModifierPlugins().get(string);
        if (iSegmentModifier == null) {
            return;
        }
        Set<String> set2 = iSegmentModifier.getDefinition().getNonOptionalParameters();
        if (set2 == null) {
            return;
        }
        parameterMap.addErrorIfNotExist(set2, evaluationState);
    }

    public static void addErrorForUnknownParameters(ParameterMap parameterMap, Set<String> set, boolean bl, EvaluationState evaluationState) {
        Object object;
        String string;
        Object object2 = null;
        if (bl) {
            string = SegmentParser.getModifyConstant(parameterMap, evaluationState, false);
            object = evaluationState.namespaceMgr.getCurrentNamespace().getSegmentModifierPlugins().get(string);
            if (object != null) {
                object2 = object.getDefinition().getAllParameters();
            }
        }
        if (object2 == null) {
            parameterMap.addErrorsForUnknownParameters(set, evaluationState);
            return;
        }
        string = object2;
        object = arg_0 -> SegmentParser.lambda$addErrorForUnknownParameters$0(set, (Set)((Object)string), arg_0);
        parameterMap.addErrorsForUnknownParameters((Predicate<String>)object, evaluationState);
    }

    private static Value getConstant(ParameterMap parameterMap, String string, EvaluationState evaluationState, boolean bl) {
        ExprNode exprNode = parameterMap.getExpr(string);
        if (exprNode == null) {
            return null;
        }
        Value value = exprNode.GetConstantValue(evaluationState);
        if (value == null && bl) {
            SourceRange sourceRange = parameterMap.getNameRange(string);
            evaluationState.diagnosticMgr.add(new AsmError("'" + string + "' must be a constant expression", sourceRange));
        }
        return value;
    }

    private static String getModifyConstant(ParameterMap parameterMap, EvaluationState evaluationState, boolean bl) {
        Value value = SegmentParser.getConstant(parameterMap, param_modify, evaluationState, bl);
        if (value == null) {
            return null;
        }
        String string = value.getString(parameterMap.getNameRange(param_modify));
        return string;
    }

    private static /* synthetic */ boolean lambda$addErrorForUnknownParameters$0(Set set, Set set2, String string) {
        return set.contains(string) || set2.contains(string);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(param_prgFiles, param_sidFiles, param_allowOverlap, param_segments, param_min, param_max, param_fill, param_fillByte, param_hide, param_modify));
        codeInputParameters = new HashSet<String>(Arrays.asList(param_start, param_startAfter, param_virtual, param_align, param_outPrg, param_outBin, param_bank, param_loadInto, param_dest));
        codeInputParameters.addAll(hashSet);
        combiParameters = new HashSet<String>();
        combiParameters.addAll(hashSet);
    }
}

